/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.world;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

public class WorldEvent
extends Event {
    private final LevelAccessor world;

    public WorldEvent(LevelAccessor world) {
        this.world = world;
    }

    public LevelAccessor getWorld() {
        return this.world;
    }

    @Cancelable
    public static class PotentialSpawns
    extends WorldEvent {
        private final MobCategory mobcategory;
        private final BlockPos pos;
        private final List<MobSpawnSettings.SpawnerData> list;
        private final List<MobSpawnSettings.SpawnerData> view;

        public PotentialSpawns(LevelAccessor level, MobCategory category, BlockPos pos, WeightedRandomList<MobSpawnSettings.SpawnerData> oldList) {
            super(level);
            this.pos = pos;
            this.mobcategory = category;
            this.list = !oldList.m_146337_() ? new ArrayList<MobSpawnSettings.SpawnerData>(oldList.m_146338_()) : new ArrayList<MobSpawnSettings.SpawnerData>();
            this.view = Collections.unmodifiableList(this.list);
        }

        public MobCategory getMobCategory() {
            return this.mobcategory;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public List<MobSpawnSettings.SpawnerData> getSpawnerDataList() {
            return this.view;
        }

        public void addSpawnerData(MobSpawnSettings.SpawnerData data) {
            this.list.add(data);
        }

        public boolean removeSpawnerData(MobSpawnSettings.SpawnerData data) {
            return this.list.remove(data);
        }
    }

    @Cancelable
    public static class CreateSpawnPosition
    extends WorldEvent {
        private final ServerLevelData settings;

        public CreateSpawnPosition(LevelAccessor world, ServerLevelData settings) {
            super(world);
            this.settings = settings;
        }

        public ServerLevelData getSettings() {
            return this.settings;
        }
    }

    public static class Save
    extends WorldEvent {
        public Save(LevelAccessor world) {
            super(world);
        }
    }

    public static class Unload
    extends WorldEvent {
        public Unload(LevelAccessor world) {
            super(world);
        }
    }

    public static class Load
    extends WorldEvent {
        public Load(LevelAccessor world) {
            super(world);
        }
    }
}

